precision mediump float;
varying vec2 v_texPosition;         // 纹理位置 接收于顶点着色器
uniform sampler2D sampler_y;        // 纹理y
uniform sampler2D sampler_u;        // 纹理u
uniform sampler2D sampler_v;        // 纹理v
uniform bool sample_yuv400;         // 是否是YUV400 只有Y向量色值

// yuv -> rgb
void main() {
    vec3 rgb;
    float y, u, v;
    y = texture2D(sampler_y, v_texPosition).r;
    u = texture2D(sampler_u, v_texPosition).r- 0.5;
    v = texture2D(sampler_v, v_texPosition).r- 0.5;

    //RGB 转 灰度图 Gray = 0.3 * R + 0.59 * G + 0.11 * B
    if (sample_yuv400) {
        rgb.r = y;
        rgb.b = y;
        rgb.g = y;
    } else {
        rgb.r = y + 1.403 * v;
        rgb.b = y + 1.770 * u;
        rgb.g = y - 0.344 * u - 0.714 * v;
    }
    // 针对于红蓝发色可以做rb颜色转换
    // gl_FragColor：GL中默认定义的输出变量，决定了当前片段的最终颜色
    gl_FragColor = vec4(rgb, 1);
}
