precision mediump float;
varying vec2 v_texPosition;
uniform sampler2D sTexture;

// 主要用于处理红蓝反色的片元着色处理
void main() {
    vec4 source_rgba = texture2D(sTexture, v_texPosition);  // rgba
    vec4 rgba;
    rgba.r = source_rgba.b;                                 // 红蓝反色 R-B
    rgba.b = source_rgba.r;                                 // 红蓝反色 B-R
    rgba.g = source_rgba.g;                                 // 颜色处理 G-G
    rgba.a = source_rgba.a;                                 // 颜色处理 A-A
    gl_FragColor = rgba;
}
